<?php
/**
 * Add new Element
 *
 * @package     Wow_Plugin
 * @subpackage  Admin/Add_Item
 * @author      Dmytro Lobov <d@dayes.dev>
 * @copyright   2019 Wow-Company
 * @license     GNU Public License
 * @version     1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// include the database params for item
include_once( 'include-data.php' );

// include the settings param
include_once( 'add-new/settings/add-new.php' );

$url_form = admin_url() . 'admin.php?page=' . esc_attr( $this->plugin['slug'] );

?>
    <form action="<?php echo esc_url( $url_form ); ?>" method="post" name="post" class="wow-plugin" id="wow-plugin">
        <div id="poststuff">
            <div id="post-body" class="metabox-holder columns-2">

                <!--      Block with the Title and content-->
                <div id="post-body-content" style="position: relative;">

                    <div id="titlediv">

                        <div id="titlewrap">
                            <label class="screen-reader-text" id="title-prompt-text" for="title">Enter title
                                here</label>
                            <input type="text" name="title" size="30" value="<?php echo esc_attr( $title ); ?>"
                                   id="title"
                                   placeholder="<?php esc_attr_e( 'Register an item name', $this->plugin['text'] ); ?>">
                        </div>

                    </div>
                </div>

                <!--      Sidebar with the setting-->
                <div id="postbox-container-1" class="postbox-container">

					<?php include_once( 'add-new/targeting.php' ); // Include the targets ?>

                    <div id="submitdiv" class="postbox ">
                        <h2 class="hndle ui-sortable-handle">
                            <span><?php esc_html_e( 'Publish', $this->plugin['text'] ); ?></span>
							<?php self::pro(); ?>
                        </h2>

                        <div class="inside">


                            <div class="container">
                                <div class="element">
									<?php self::option( $show ); ?>

                                    <span id="shortcode">
                  <code>[<?php echo esc_attr( $this->plugin['shortcode'] ); ?> id="<?php echo absint( $tool_id ); ?>"]</code>
                </span>
                                </div>
                            </div>

                            <div class="submitbox" id="submitpost">

                                <div id="major-publishing-actions">

                                    <div id="delete-action">
										<?php if ( ! empty( $id ) ) {
											echo '<a class="submitdelete deletion" href="admin.php?page=' . esc_attr( $this->plugin['slug'] ) .
											     '&info=delete&did=' . absint( $id ) . '">' . esc_attr__( 'Delete', $this->plugin['text'] ) . '</a>';
										}; ?>
                                    </div>

                                    <div id="publishing-action">
                                        <span class="saving"><?php esc_html_e( 'Saving', $this->plugin['text'] ); ?></span>
                                        <input name="submit" id="submit" class="button button-primary button-large"
                                               value="<?php echo esc_attr( $btn ); ?>" type="submit">
                                    </div>

                                    <div class="clear"></div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!--      Block for main settings pages-->
                <div id="postbox-container-2" class="postbox-container">
                    <div id="postoptions" class="postbox ">
                        <div class="inside">

                            <div class="tab-box">
                                <ul class="tab-nav">
									<?php
									$tab_menu = array(
										'main' => __( 'Settings', $this->plugin['text'] ),
										'menu' => __( 'Menu', $this->plugin['text'] ),

									);
									$i        = 1;
									foreach ( $tab_menu as $menu => $val ) {
										echo '<li><a href="#t' . absint( $i ) . '">' . esc_html( $val ) . '</a></li>';
										$i ++;
									}
									?>
                                </ul>
                                <div class="tab-panels">
									<?php
									$t = 1;
									foreach ( $tab_menu as $menu => $val ) {
										echo '<div id="t' . absint( $t ) . '">';
										include_once( 'add-new/' . esc_attr( $menu ) . '.php' );
										echo '</div>';
										$t ++;
									}
									?>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>

        <!--  main param for adding in database-->
        <input type="hidden" name="tool_id" value="<?php echo absint( $tool_id ); ?>" id="tool_id"/>
        <input type="hidden" name="add" id="add_action" value="<?php echo absint( $add_action ); ?>"/>
        <input type="hidden" name="prefix" value="<?php echo esc_attr( $this->plugin['prefix'] ); ?>" id="prefix"/>
		<?php wp_nonce_field( $this->plugin['slug'] . '_action', $this->plugin['slug'] . '_nonce' ); ?>

    </form>

    <div id="clone" style="display: none;">
		<?php include_once( 'add-new/clone.php' ); ?>
    </div>

<?php
